﻿using Microsoft.Xrm.Sdk;
using System;
using System.Xml;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VA.PPMS.Context;
using VA.PPMS.CRM.Plugins.Data;

namespace VA.PPMS.CRM.Plugins.Helper
{
    public static class SettingsHelper
    {
        public static PpmsServiceSettings GetSettings(IOrganizationService orgService)
        {
            return GetSettings(orgService, "DEV Integration Settings");
        }

        public static PpmsServiceSettings GetSettings(IOrganizationService orgService, string settingName)
        {
            using (var svc = new PpmsContext(orgService))
            {
                if (svc == null) return new PpmsServiceSettings("Context could not be created.");

                var settings = svc.ppms_integrationsettingsSet.FirstOrDefault(i => i.ppms_name == settingName);

                if (settings == null) return new PpmsServiceSettings("Settings could not be found in the current environment.");

                return new PpmsServiceSettings(settings);
            }
        }
        /// <summary>
        /// GetValueFromKey - returns the value of the key, or empty string ... all errors are hiddne, empty result is the only indication of an error
        /// </summary>
        /// <param name="secure"></param>
        /// <param name="key"></param>
        /// <returns></returns>
        public static string GetValueFromKey(string secure, string key)
        {
            string value = "";
            try
            {
                var xmlDoc = XmlHelper.LoadParameters(secure);
                XmlNodeList l = xmlDoc.GetElementsByTagName(key);
                if (l.Count > 0)
                {
                    value = l[0].InnerText;
                }
            }
            catch (Exception)
            {
                value = ""; // always return empty
            }
            return value;
        }
    }
}
